create table accounts_enc (
	acc_no            number 	not null,
	first_name         varchar2(30) 	not null,
	last_name          varchar2(30) 	not null,
	acc_type           varchar2(15) ,
	acc_open_dt        date ,
	acc_mgr_id                 number,
	city		varchar2(30),
	street_name	varchar2(30)
)
tablespace enc128_ts
/
create table accounts_reg (
	acc_no            number 	not null,
	first_name         varchar2(30) 	not null,
	last_name          varchar2(30) 	not null,
	acc_type           varchar2(15) ,
	acc_open_dt        date ,
	acc_mgr_id                 number,
	city		varchar2(30),
	street_name	varchar2(30)
)
tablespace normal_ts
/
begin
   for l_acc_no in 1..1000000 loop
   insert into accounts_&reg_or_enc
   values  
   (
      l_acc_no,     
      -- First Name
      decode (         
         floor(dbms_random.value(1,21)),
         1, 'Alan',
         2, 'Alan',
         3, 'Barbara',
         4, 'Barbara',
         5, 'Charles',
         6, 'David',
         7, 'Ellen',
         8, 'Ellen',
         9, 'Ellen',
         10, 'Frank',
         11, 'Frank',
         12, 'Frank',
         13, 'George',
         14, 'George',
         15, 'George',
         16, 'Hillary',
         17, 'Iris',
         18, 'Iris',
         19, 'Josh',        
         20, 'Josh',           
             'XXX'
      ),
      -- Last Name
      decode (        
         floor(dbms_random.value(1,11)),           
            1,'Smith',           
            2,'Smith',           
            3,'Smith',           
            4,'Freeman',           
            5,'Alapati',           
            6,'Joseph',           
            7,'Nanda',           
            8,'Feuerstein',           
            9,'Burleson',           
           10,'Kuhn',           
		'XXX'
      ),
      -- Account Type
      decode (        
         floor(dbms_random.value (1,5)),           
             1,'Savings',
             2,'Checking',
             3,'Money Market',
             4,'Home Equity',
               'Miscellaneous'     
      ),
      -- Acc Opening Date
      sysdate - dbms_random.value(1,50),
      -- Account Manager ID
      decode (        
         floor(dbms_random.value (1,11)),           
            1,1000,2,1000,3,1000,4,1000,5,2000,
            6,3000,7,4000,8,5000,9,5000,10,5000,0     
      ),
      -- City
      decode (        
         floor(dbms_random.value (1,11)),           
             1,'New York',
             2,'Danbury',
             3,'Rutherford Hills',
             4,'Mariden City',
             5,'Crystal City',
             6,'Florham Park',
             7,'Mountain View',
             8,'New York',
             9,'White Plains',
            10,'Long Island City',
               'XXX'
      ),
      -- Street Name
      decode (        
         floor(dbms_random.value (1,11)),           
             1,'Raspenberry Hills Lane',
             2,'Grenier Drive',
             3,'Throghs Neck Bridge Road',
             4,'Palisades Parkway',
             5,'Bronx River Parkway',
             6,'Whitestone Bridge Road',
             7,'Long Island Expressway',
             8,'New England Expressway',
             9,'New York State Thruway',
            10,'Cross Bronx Parkway',
                'XXX'
      )
   );
   end loop;
   commit;
end;
/
commit;
create index in_acc_enc_fn
on accounts_enc (first_name)
tablespace enc128_ts
/
create index in_acc_reg_fn
on accounts_reg (first_name)
tablespace normal_ts
/
begin
   dbms_stats.gather_table_stats (
		ownname => 'ARUP',
		tabname => 'ACCOUNTS_ENC',
		estimate_percent => 100,
		cascade => true
	);
end;
/
begin
   dbms_stats.gather_table_stats (
		ownname => 'ARUP',
		tabname => 'ACCOUNTS_REG',
		estimate_percent => 100,
		cascade => true
	);
end;
/ 