create or replace package associative_array as
  -- define an associative array type for each column in the jobs table

  type t_job_id is table of jobs.job_id%type index by pls_integer;
  type t_job_title is table of jobs.job_title%type index by pls_integer;
  type t_min_salary is table of jobs.min_salary%type index by pls_integer;
  type t_max_salary is table of jobs.max_salary%type index by pls_integer;


  -- define the procedure that will perform the array insert

  procedure array_insert (p_job_id in t_job_id,
                          p_job_title in t_job_title,
                          p_min_salary in t_min_salary,
                          p_max_salary in t_max_salary);
end associative_array;
/


create or replace package body associative_array as
  -- implement the procedure that will perform the array insert

  procedure array_insert (p_job_id in t_job_id,
                          p_job_title in t_job_title,
                          p_min_salary in t_min_salary,
                          p_max_salary in t_max_salary) is
  begin
    forall i in p_job_id.first..p_job_id.last
    insert into jobs (job_id,
                      job_title,
                      min_salary,
                      max_salary)
              values (p_job_id(i),
                      p_job_title(i),
                      p_min_salary(i),
                      p_max_salary(i));
  end array_insert;
end associative_array;
/
