const CUSTOMOBJECT_CONVERSATION_MAP = {};

ORACLE_SERVICE_CLOUD.extension_loader.load("logging_feedback_agentask", "1").then(function (extensionProvider) {
    extensionProvider.getGlobalContext().then(async function (globalContext) {
        var restInterfaceServiceUrl = globalContext.getInterfaceServiceUrl('REST');
        // var restInterfaceServiceUrl = 'https://phoenix341658.appsdev.fusionappsdphx1.oraclevcn.com:4000/services/rest';
        var token = await globalContext.getSessionToken();
        globalContext.registerAction('log_agentask', async (param) => {
            try {
                const apiResponse = await makeCall(`${restInterfaceServiceUrl}/connect/v1.4/CO.ASKAgentFeedback`, 'POST', token, {
                    "Name": param.conversationId,
                    "Question": param.requestPayload.question,
                    "BotAnswer": param.response.answer,
                    "conversationId": param.conversationId
                });
                const responsData = await apiResponse.json();
                CUSTOMOBJECT_CONVERSATION_MAP[param.conversationId] = responsData.id;
            } catch (e) {
            }
        });


        globalContext.registerAction('feedback_agentask', async (param) => {
            if (param && param.conversation && param.conversation.conversationId) {
                try {
                    const customObjectId = CUSTOMOBJECT_CONVERSATION_MAP[param.conversation.conversationId];
                    if (customObjectId) {
                        const apiResponse = await makeCall(`${restInterfaceServiceUrl}/connect/v1.4/CO.ASKAgentFeedback/${customObjectId}`, 'PATCH', token, {
                            "Feedback": param.type === 'like' ? 1 : -1
                        });
                        const responsData = await apiResponse.json();
                        CUSTOMOBJECT_CONVERSATION_MAP[param.conversationId] = responsData.id;
                    }
                } catch (e) {
                }
            }
        });

        globalContext.registerAction('enrichanswer', function (param) {
            param.payload = { "accountId": param.accountId, "additionalAttributes": param.additionalAttributes, "answer": convertMarkdownLinksToTagLinks(param.answer), "completeChatHistoryAvailable": param.completeChatHistoryAvailable, "conversationId": param.conversationId, "genAIChatStatus": param.genAIChatStatus, "welcomeMessage": param.welcomeMessage }
            return param.payload;
        });

        globalContext.registerAction('enrichquestion', function (param) {
            param.payload = { "question": "Context: Coffee Machine\nReply in HTML format including hyperlinks\n" + param.question, "useCaseType": param.useCaseType, "moduleType": param.moduleType, "chatHistory": param.chatHistory, "connectionType": param.connectionType, "accountId": param.accountId, "conversationId": param.conversationId }
            return param;
        });
    });
});

function convertMarkdownLinksToTagLinks(text) {
    const markdownLinkRegex = /\[([a-z0-9-]+)\]\((https?:\/\/[^\s)]+)\)/gi;

    return text.replace(markdownLinkRegex, (match, tag, url) => {
        return `<a href="${url}" target="_blank" class="tag">${tag}</a>`;
    });
}

async function makeCall(restUrl, method, token, data) {
    const myHeaders = new Headers();
    myHeaders.append("OSvC-CREST-Application-Context", "agentask_logs");
    myHeaders.append("Content-Type", "application/json");
    myHeaders.append("Authorization", `Session ${token}`);
    payload = JSON.stringify(data);

    const requestOptions = {
        method: method,
        headers: myHeaders,
        body: payload
    };

    return fetch(restUrl, requestOptions);
}