/*!
 ##################################################################################
 # @file Interview Extensions Script / Google Maps JavaScript API integration
 # @author Robert Surujbhan <robert.surujbhan@oracle.com>
 # @copyright 2020, Oracle Corporation. All rights reserved.
 # https://www.oracle.com
 ##################################################################################
 */

var MAP_DIV_ID = "map-canvas";
var map;
var mapDiv;
var infoWindow;
var geocoder;
var myMarker;

OraclePolicyAutomation.AddExtension({
    customContainer: function (control, interview) {
        var opaLat;
        var opaLng;
        var coordinatesReady = false;
        if (control.getProperty("type") === "map") {
            return {
                mount: function (el) {
                    var self = this;
                    var pageHead = document.getElementsByTagName('head')[0];
                    var gMapsScript = document.createElement('script');
                    gMapsScript.type = 'text/javascript';
                    gMapsScript.async = true;
                    gMapsScript.defer = true;
                    gMapsScript.onload = function () {
                        var sTimer = setInterval(function () {
                            if (coordinatesReady) {
                                clearInterval(sTimer);
                                self.initMap(self, opaLat, opaLng);
                            }
                            else {
                                var extensionData = interview.getExtensionData();
                                opaLat = Number(extensionData["latitude"]);
                                opaLng = Number(extensionData["longitude"]);
                                
                                if(typeof opaLat === 'number' && typeof opaLng === 'number' && Math.abs(opaLat) <= 90 && Math.abs(opaLng) <= 180) {
                                    coordinatesReady = true;
                                }
                            }
                        }, 100);
                    }
                    gMapsScript.src = 'https://maps.googleapis.com/maps/api/js?key=' + control.getProperty("apiKey");
                    pageHead.appendChild(gMapsScript);

                    mapDiv = document.createElement("div");
                    mapDiv.id = MAP_DIV_ID;
                    mapDiv.style.visibility = 'visible';
                    mapDiv.style.height = control.getProperty("mapHeight");
                    mapDiv.style.width = control.getProperty("mapWidth");
                    mapDiv.style.margin = '0px';
                    mapDiv.style.padding = '0px';
                    mapDiv.style.outline = 'rgb(114, 119, 128) solid 1px';

                    el.appendChild(mapDiv);
                },
                initMap: function (ccObj, lat, long) {
                    geocoder = new google.maps.Geocoder();
                    infoWindow = new google.maps.InfoWindow();
                    var initLatLng = new google.maps.LatLng(lat, long);
                    var myOptions = {
                        zoom: parseInt(control.getProperty("mapZoom")),
                        center: initLatLng,
                        mapTypeId: google.maps.MapTypeId.ROADMAP
                    };

                    map = new google.maps.Map(mapDiv, myOptions);

                    myMarker = new google.maps.Marker({
                        draggable: true,
                        position: initLatLng,
                        map: map,
                        title: "The location of the incident"
                    });

                    map.addListener('click', function (event) {
                        var newLat = event.latLng.lat();
                        var newLng = event.latLng.lng();
                        interview.setInputValue('latitude', newLat);
                        interview.setInputValue('longitude', newLng);

                        myMarker.setPosition(event.latlng);
                        map.setCenter(event.latlng);
                        ccObj.geocodeLatLng(geocoder, map, infoWindow, event, myMarker);
                    });
                },
                geocodeLatLng: function (geocoder, map, iwindow, event, marker) {
                    var latlng = {
                        lat: parseFloat(event.latLng.lat()),
                        lng: parseFloat(event.latLng.lng())
                    };
                    geocoder.geocode({
                        'location': latlng
                    },
                        function (results, status) {
                            if (status === 'OK') {
                                if (results[0]) {
                                    marker.setPosition(latlng);
                                    var content = document.createElement('div');
                                    var content = results[0].formatted_address;
                                    iwindow.setContent(content);
                                    iwindow.open(map, marker);
                                    interview.setInputValue('address', content);
                                } else {
                                    window.alert('No results found');
                                }
                            } else {
                                window.alert('Geocoder failed due to: ' + status);
                            }
                        });
                },
                update: function (el) {
                    return;
                },
                unmount: function (el) {
                    if (control.getProperty("type") === "map") {
                        var map = document.getElementById(MAP_DIV_ID);
                        map.remove();
                        window.google = {};
                    }
                }
            }
        }
    }
});