OraclePolicyAutomation.AddExtension({
    customInput: function(control, interview) {
        if (control.getDataType() === "text" && control.getProperty("barcode") === "true") {
            let inputEl;
            let fileInputEl;

            function onBarcodeScan() {
                let quaggaConfig = {
                    decoder: {
                        readers: ["code_128_reader",
                            "ean_reader",
                            "ean_8_reader",
                            "code_39_reader",
                            "code_39_vin_reader",
                            "codabar_reader",
                            "upc_reader",
                            "upc_e_reader",
                            "i2of5_reader"
                        ]
                    },
                    locate: true,
                    src: URL.createObjectURL(this.files[0])
                }

                Quagga.decodeSingle(quaggaConfig, handleScanResult);
            }

            function handleScanResult(result) {
            	console.log(result)
                if (result && result.codeResult) {
                    inputEl.value = result.codeResult.code;
                    control.setValue(result.codeResult.code);
                }
            }

            return {
                mount: function(el) {
                	let barcodeControlDiv = document.createElement("div");
                	barcodeControlDiv.setAttribute("class", "barcode-control-container");

                    inputEl = document.createElement("input");
                    inputEl.setAttribute("type", "text");
                    inputEl.setAttribute("class", "barcode-input-field");

                    inputEl.oninput = function() {
                    	let v = inputEl.value;
                    	control.setValue(v);
                    }

                    let uploadLabelEl = document.createElement("label");
                    uploadLabelEl.setAttribute("class", "barcode-scan-button");

                    let barcodeIconImg = document.createElement("img");
                    barcodeIconImg.setAttribute("src", interview.resourcePath + "/images/barcode.svg");

                    fileInputEl = document.createElement("input");
                    fileInputEl.setAttribute("type", "file");
                    fileInputEl.setAttribute("accept", "image/*;capture=camera");
                    fileInputEl.setAttribute("capture", "camera");
                    fileInputEl.addEventListener("change", onBarcodeScan, false);
                    fileInputEl.style.display = "none";

                    barcodeControlDiv.appendChild(inputEl);

                    uploadLabelEl.appendChild(barcodeIconImg);
                    uploadLabelEl.appendChild(fileInputEl);
                    barcodeControlDiv.appendChild(uploadLabelEl);

                    el.appendChild(barcodeControlDiv);
                }
            }
        }
    }
});