prompt --application/shared_components/automations/get_ingestion_status
begin
--   Manifest
--     AUTOMATION: Get Ingestion Status
--   Manifest End
wwv_flow_imp.component_begin (
 p_version_yyyy_mm_dd=>'2024.11.30'
,p_release=>'24.2.11'
,p_default_workspace_id=>7933254040897261
,p_default_application_id=>194
,p_default_id_offset=>217939551778601217
,p_default_owner=>'WKSP_WSDEMO'
);
wwv_flow_imp_shared.create_automation(
 p_id=>wwv_flow_imp.id(353676319408167479)
,p_name=>'Get Ingestion Status'
,p_static_id=>'get-ingestion-status'
,p_trigger_type=>'POLLING'
,p_polling_interval=>'FREQ=MINUTELY;INTERVAL=2'
,p_polling_status=>'DISABLED'
,p_result_type=>'ROWS'
,p_location=>'LOCAL'
,p_use_local_sync_table=>false
,p_query_type=>'TABLE'
,p_query_table=>'DOC_UPLOAD'
,p_include_rowid_column=>false
,p_commit_each_row=>false
,p_error_handling_type=>'IGNORE'
);
wwv_flow_imp_shared.create_automation_action(
 p_id=>wwv_flow_imp.id(353676644386167480)
,p_automation_id=>wwv_flow_imp.id(353676319408167479)
,p_name=>'Get Ingestion Job Status'
,p_execution_sequence=>10
,p_action_type=>'NATIVE_PLSQL'
,p_action_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'  l_ing_jobid varchar2(300);',
'  l_response clob;',
'  l_json varchar2(1000);',
'  l_status varchar2(100);',
'  l_region varchar2(100);',
'  l_cred varchar2(20);',
'',
'  cursor c_jobid is select id, DATA_ING_JOB_ID,INGESTION_RESPONSE from doc_upload where upper(INGESTION_RESPONSE) <> ''SUCCEEDED'';',
'',
'begin',
'apex_web_service.set_request_headers(',
'    p_name_01 => ''Content-Type''',
'    , p_value_01 => ''application/json''',
'  );',
'',
'l_region :=  apex_app_setting.get_value(p_name => ''REGION'');',
'l_cred   := apex_app_setting.get_value(p_name => ''OCI_AI_CRED'');',
'FOR i in c_jobid',
'   LOOP',
'    l_ing_jobid := i.DATA_ING_JOB_ID;',
'',
'     l_response := apex_web_service.make_rest_request(',
'    p_http_method => ''GET''',
'    , p_url => ''https://agent.generativeai.''',
'                ||l_region',
'                ||''.oci.oraclecloud.com/20240531/dataIngestionJobs/''',
'                || l_ing_jobid',
'    , p_credential_static_id => l_cred',
'  );',
'',
'SELECT jt.Status into l_status',
'FROM JSON_TABLE(',
'    l_response,',
'    ''$''',
'    COLUMNS (',
'        Status VARCHAR2(50) PATH ''$.lifecycleState''',
'    )',
') jt;',
'',
'update doc_upload set INGESTION_RESPONSE = l_status where id = i.id;',
'    dbms_output.Put_line(l_response);',
'   END LOOP;',
'end;'))
,p_action_clob_language=>'PLSQL'
,p_location=>'LOCAL'
,p_stop_execution_on_error=>true
);
wwv_flow_imp.component_end;
end;
/
