prompt --application/pages/page_00010
begin
--   Manifest
--     PAGE: 00010
--   Manifest End
wwv_flow_imp.component_begin (
 p_version_yyyy_mm_dd=>'2024.11.30'
,p_release=>'24.2.11'
,p_default_workspace_id=>7933254040897261
,p_default_application_id=>194
,p_default_id_offset=>217939551778601217
,p_default_owner=>'WKSP_WSDEMO'
);
wwv_flow_imp_page.create_page(
 p_id=>10
,p_name=>'Getting Started'
,p_alias=>'GETTING-STARTED2'
,p_step_title=>'Getting Started'
,p_autocomplete_on_off=>'OFF'
,p_inline_css=>wwv_flow_string.join(wwv_flow_t_varchar2(
'.step-container { max-width: 1168px; margin: 1.6rem auto }',
'.step-container .t-HeroRegion:not(.t-HeroRegion--featured) .t-HeroRegion-wrap { padding: 0 }',
'.t-Alert--info .t-Alert-icon { vertical-align: top }',
'.t-Alert--horizontal .t-Alert-title { line-height: 2.8rem }',
'.content-well { background: rgba(0, 0, 0, .05); border-radius: 2px; padding: 1.6rem }',
'.users-table .t-Report-report thead { display: none }',
'.users-table .t-Report-cell { padding: 0.8rem 0; font-size: 1.4rem; line-height: 1.5 }',
'.cta-button {padding: 16px 32px; font-size: 16px;}',
'.t-Card-info {',
'  margin-top: 0;',
'}',
'',
'.t-Card-desc {',
'  display: none;',
'}',
'',
'.t-Card-title {',
'  font-weight: 400;',
'}',
'.apex-item-yes-no {white-space:pre;}'))
,p_step_template=>2979075366320325194
,p_page_template_options=>'#DEFAULT#'
,p_protection_level=>'C'
,p_help_text=>'Use this items on this page to configure the app.'
,p_page_component_map=>'16'
);
wwv_flow_imp_page.create_page_plug(
 p_id=>wwv_flow_imp.id(359485026353607545)
,p_plug_name=>'Introduction Wizard Container'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>3371237801798025892
,p_plug_display_sequence=>10
,p_location=>null
,p_ai_enabled=>false
,p_attributes=>wwv_flow_t_plugin_attributes(wwv_flow_t_varchar2(
  'expand_shortcuts', 'N',
  'output_as', 'HTML')).to_clob
);
wwv_flow_imp_page.create_page_plug(
 p_id=>wwv_flow_imp.id(326369405757017862)
,p_plug_name=>'Enter OCI Generative AI Agent Details'
,p_parent_plug_id=>wwv_flow_imp.id(359485026353607545)
,p_region_css_classes=>'step-container'
,p_icon_css_classes=>'fa-number-1'
,p_region_template_options=>'#DEFAULT#:t-Alert--horizontal:t-Alert--customIcons:t-Alert--info'
,p_plug_template=>2040683448887306517
,p_plug_display_sequence=>30
,p_plug_display_point=>'SUB_REGIONS'
,p_location=>null
,p_plug_source=>'<p>Enter the Endpoint OCID of the OCI Generative Agents you want to use.</p>'
,p_ai_enabled=>false
,p_attributes=>wwv_flow_t_plugin_attributes(wwv_flow_t_varchar2(
  'expand_shortcuts', 'N',
  'output_as', 'HTML')).to_clob
);
wwv_flow_imp_page.create_page_plug(
 p_id=>wwv_flow_imp.id(326417613750604262)
,p_plug_name=>'Enter Object Storage Details'
,p_parent_plug_id=>wwv_flow_imp.id(359485026353607545)
,p_region_css_classes=>'step-container'
,p_icon_css_classes=>'fa-number-3'
,p_region_template_options=>'#DEFAULT#:t-Alert--horizontal:t-Alert--customIcons:t-Alert--info'
,p_plug_template=>2040683448887306517
,p_plug_display_sequence=>50
,p_plug_display_point=>'SUB_REGIONS'
,p_location=>null
,p_ai_enabled=>false
,p_attributes=>wwv_flow_t_plugin_attributes(wwv_flow_t_varchar2(
  'expand_shortcuts', 'N',
  'output_as', 'HTML')).to_clob
);
wwv_flow_imp_page.create_page_plug(
 p_id=>wwv_flow_imp.id(379296249731163291)
,p_plug_name=>'Introduction Wizard'
,p_parent_plug_id=>wwv_flow_imp.id(359485026353607545)
,p_region_css_classes=>'step-container'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>4501440665235496320
,p_plug_display_sequence=>20
,p_plug_display_point=>'SUB_REGIONS'
,p_location=>null
,p_ai_enabled=>false
,p_attributes=>wwv_flow_t_plugin_attributes(wwv_flow_t_varchar2(
  'expand_shortcuts', 'N',
  'output_as', 'HTML')).to_clob
);
wwv_flow_imp_page.create_page_plug(
 p_id=>wwv_flow_imp.id(379296261246163292)
,p_plug_name=>'Welcome to Sample OCI AI Agents Integrated Application'
,p_parent_plug_id=>wwv_flow_imp.id(379296249731163291)
,p_region_template_options=>'t-HeroRegion--noPadding'
,p_plug_template=>2674017834225413037
,p_plug_display_sequence=>10
,p_plug_display_point=>'SUB_REGIONS'
,p_location=>null
,p_plug_source=>'Please take a moment to complete this first time setup.'
,p_region_image=>'#APP_FILES#icons/app-icon-512.png'
,p_ai_enabled=>false
,p_attributes=>wwv_flow_t_plugin_attributes(wwv_flow_t_varchar2(
  'expand_shortcuts', 'N',
  'output_as', 'HTML')).to_clob
);
wwv_flow_imp_page.create_page_plug(
 p_id=>wwv_flow_imp.id(379296506616163294)
,p_plug_name=>'Enter OCI Web Credentials'
,p_title=>'Enter Web Credentials'
,p_parent_plug_id=>wwv_flow_imp.id(359485026353607545)
,p_region_css_classes=>'step-container'
,p_icon_css_classes=>'fa-number-2'
,p_region_template_options=>'#DEFAULT#:t-Alert--horizontal:t-Alert--customIcons:t-Alert--info'
,p_plug_template=>2040683448887306517
,p_plug_display_sequence=>40
,p_plug_display_point=>'SUB_REGIONS'
,p_plug_item_display_point=>'BELOW'
,p_location=>null
,p_plug_source=>'<p>Enter the OCI credentials you would like to use for this application.</p>'
,p_ai_enabled=>false
,p_attributes=>wwv_flow_t_plugin_attributes(wwv_flow_t_varchar2(
  'expand_shortcuts', 'N',
  'output_as', 'HTML')).to_clob
);
wwv_flow_imp_page.create_page_plug(
 p_id=>wwv_flow_imp.id(397133122291984045)
,p_plug_name=>'Web Credentials'
,p_parent_plug_id=>wwv_flow_imp.id(379296506616163294)
,p_region_template_options=>'#DEFAULT#:t-Region--removeHeader js-removeLandmark:t-Region--noBorder:t-Region--hiddenOverflow'
,p_plug_template=>4072358936313175081
,p_plug_display_sequence=>40
,p_plug_display_point=>'SUB_REGIONS'
,p_location=>null
,p_ai_enabled=>false
,p_attributes=>wwv_flow_t_plugin_attributes(wwv_flow_t_varchar2(
  'expand_shortcuts', 'N',
  'output_as', 'HTML')).to_clob
);
wwv_flow_imp_page.create_page_plug(
 p_id=>wwv_flow_imp.id(379296663069163296)
,p_plug_name=>'Button OCI'
,p_parent_plug_id=>wwv_flow_imp.id(359485026353607545)
,p_region_css_classes=>'step-container'
,p_region_template_options=>'#DEFAULT#:t-ButtonRegion--noUI'
,p_plug_template=>2126429139436695430
,p_plug_display_sequence=>60
,p_plug_display_point=>'SUB_REGIONS'
,p_location=>null
,p_ai_enabled=>false
,p_attributes=>wwv_flow_t_plugin_attributes(wwv_flow_t_varchar2(
  'expand_shortcuts', 'N',
  'output_as', 'HTML')).to_clob
);
wwv_flow_imp_page.create_page_button(
 p_id=>wwv_flow_imp.id(310700690737921411)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_imp.id(379296663069163296)
,p_button_name=>'COMPLETE_OCI'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#:t-Button--iconLeft'
,p_button_template_id=>2082829544945815391
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Complete Setup'
,p_button_position=>'CHANGE'
,p_show_processing=>'Y'
,p_button_css_classes=>'cta-button'
,p_icon_css_classes=>'fa-check-circle'
);
wwv_flow_imp_page.create_page_branch(
 p_id=>wwv_flow_imp.id(310705136975921394)
,p_branch_name=>'Go to Home Page'
,p_branch_action=>'f?p=&APP_ID.:2:&SESSION.::&DEBUG.:::&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>10
,p_branch_condition_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_branch_condition=>'INITIALIZED_AI_PROVIDER'
,p_branch_condition_text=>'YES'
);
wwv_flow_imp_page.create_page_item(
 p_id=>wwv_flow_imp.id(326370565213017854)
,p_name=>'P10_OCI_AGENT_ENDPOINT'
,p_is_required=>true
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_imp.id(326369405757017862)
,p_prompt=>'OCI AI Agent Endpoint ID'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>30
,p_field_template=>2526760615038828570
,p_item_template_options=>'#DEFAULT#:t-Form-fieldContainer--stretchInputs'
,p_attributes=>wwv_flow_t_plugin_attributes(wwv_flow_t_varchar2(
  'disabled', 'N',
  'submit_when_enter_pressed', 'N',
  'subtype', 'TEXT',
  'trim_spaces', 'BOTH')).to_clob
,p_ai_enabled=>false
);
wwv_flow_imp_page.create_page_item(
 p_id=>wwv_flow_imp.id(326419385658604250)
,p_name=>'P10_COMPARTMENT_ID'
,p_is_required=>true
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_imp.id(326417613750604262)
,p_prompt=>'Compartment ID'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>30
,p_field_template=>2526760615038828570
,p_item_template_options=>'#DEFAULT#'
,p_attributes=>wwv_flow_t_plugin_attributes(wwv_flow_t_varchar2(
  'disabled', 'N',
  'submit_when_enter_pressed', 'N',
  'subtype', 'TEXT',
  'trim_spaces', 'BOTH')).to_clob
,p_ai_enabled=>false
);
wwv_flow_imp_page.create_page_item(
 p_id=>wwv_flow_imp.id(326419518949604251)
,p_name=>'P10_NAMESPACE_NAME'
,p_is_required=>true
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_imp.id(326417613750604262)
,p_prompt=>'Namespace Name'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>30
,p_field_template=>2526760615038828570
,p_item_template_options=>'#DEFAULT#'
,p_attributes=>wwv_flow_t_plugin_attributes(wwv_flow_t_varchar2(
  'disabled', 'N',
  'submit_when_enter_pressed', 'N',
  'subtype', 'TEXT',
  'trim_spaces', 'BOTH')).to_clob
,p_ai_enabled=>false
);
wwv_flow_imp_page.create_page_item(
 p_id=>wwv_flow_imp.id(326419546831604252)
,p_name=>'P10_BUCKET_NAME'
,p_is_required=>true
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_imp.id(326417613750604262)
,p_prompt=>'Bucket Name'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>30
,p_field_template=>2526760615038828570
,p_item_template_options=>'#DEFAULT#'
,p_attributes=>wwv_flow_t_plugin_attributes(wwv_flow_t_varchar2(
  'disabled', 'N',
  'submit_when_enter_pressed', 'N',
  'subtype', 'TEXT',
  'trim_spaces', 'BOTH')).to_clob
,p_ai_enabled=>false
);
wwv_flow_imp_page.create_page_item(
 p_id=>wwv_flow_imp.id(397140706646983985)
,p_name=>'P10_SHOW_WEB_CREDENTIALS'
,p_item_sequence=>40
,p_item_plug_id=>wwv_flow_imp.id(379296506616163294)
,p_item_default=>'Y'
,p_prompt=>'Edit Web Credentials'
,p_display_as=>'NATIVE_YES_NO'
,p_field_template=>2318601014859922299
,p_item_template_options=>'#DEFAULT#'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Use the <em>Edit Web Credentials</em> switch to manage your OCI Web Credentials.</p>',
'<p>Disabling the switch allows you to only edit the <em>Compartment ID</em> after successfully entering the web credentials for the first time.</p>'))
,p_attributes=>wwv_flow_t_plugin_attributes(wwv_flow_t_varchar2(
  'use_defaults', 'Y')).to_clob
,p_ai_enabled=>false
);
wwv_flow_imp_page.create_page_item(
 p_id=>wwv_flow_imp.id(397147486465983966)
,p_name=>'P10_OCI_WEB_CRED_HEADER'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_imp.id(397133122291984045)
,p_prompt=>'Web Credential'
,p_source=>'OCI Credentials'
,p_source_type=>'STATIC'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_field_template=>2318601014859922299
,p_item_template_options=>'#DEFAULT#'
,p_protection_level=>'S'
,p_help_text=>'Denotes the name of the Web Credential which is used for accessing the <strong>OCI Generative AI</strong>. Navigate to <strong>Workspace Utilities</strong>, <strong>Web Credential</strong> to review existing Web Credentials.'
,p_attributes=>wwv_flow_t_plugin_attributes(wwv_flow_t_varchar2(
  'based_on', 'VALUE',
  'format', 'PLAIN',
  'send_on_page_submit', 'Y',
  'show_line_breaks', 'Y')).to_clob
,p_ai_enabled=>false
);
wwv_flow_imp_page.create_page_item(
 p_id=>wwv_flow_imp.id(404103902641907960)
,p_name=>'P10_OCI_USER_ID'
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_imp.id(397133122291984045)
,p_prompt=>'OCI User ID'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>80
,p_field_template=>2526760615038828570
,p_item_template_options=>'#DEFAULT#:margin-top-md'
,p_help_text=>'<p>Enter the Oracle Cloud Infrastructure <em>User OCID</em>. &PRODUCT_NAME. does not store this information encrypted.</p> <p><a rel="noopener noreferrer" target="_blank" href="https://docs.cloud.oracle.com/iaas/Content/API/Concepts/apisigningkey.htm'
||'">Oracle Cloud Infrastructure Documentation</a></p>'
,p_attributes=>wwv_flow_t_plugin_attributes(wwv_flow_t_varchar2(
  'disabled', 'N',
  'submit_when_enter_pressed', 'N',
  'subtype', 'TEXT',
  'trim_spaces', 'BOTH')).to_clob
,p_ai_enabled=>false
);
wwv_flow_imp_page.create_page_item(
 p_id=>wwv_flow_imp.id(404103978846907961)
,p_name=>'P10_OCI_PRIVATE_KEY'
,p_item_sequence=>40
,p_item_plug_id=>wwv_flow_imp.id(397133122291984045)
,p_prompt=>'OCI Private Key'
,p_display_as=>'NATIVE_TEXTAREA'
,p_cSize=>80
,p_cMaxlength=>4000
,p_cHeight=>5
,p_field_template=>2526760615038828570
,p_item_template_options=>'#DEFAULT#'
,p_is_persistent=>'N'
,p_help_text=>'<p>Enter the private key in PEM format for OCI authentication. &PRODUCT_NAME. stores this information encrypted and secure, so it cannot be retrieved back in clear text.</p><p><a rel="noopener noreferrer" target="_blank" href="https://docs.cloud.orac'
||'le.com/iaas/Content/API/Concepts/apisigningkey.htm">Oracle Cloud Infrastructure Documentation</a></p>'
,p_attributes=>wwv_flow_t_plugin_attributes(wwv_flow_t_varchar2(
  'auto_height', 'N',
  'character_counter', 'N',
  'resizable', 'Y',
  'trim_spaces', 'BOTH')).to_clob
,p_ai_enabled=>false
);
wwv_flow_imp_page.create_page_item(
 p_id=>wwv_flow_imp.id(404104081894907962)
,p_name=>'P10_OCI_TENANCY_ID'
,p_item_sequence=>50
,p_item_plug_id=>wwv_flow_imp.id(397133122291984045)
,p_prompt=>'OCI Tenancy ID'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>80
,p_field_template=>2526760615038828570
,p_item_template_options=>'#DEFAULT#'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Enter the Oracle Cloud Infrastructure <em>Tenancy''s OCID</em>.</p>',
'<p><a rel="noopener noreferrer" target="_blank" href="https://docs.cloud.oracle.com/iaas/Content/API/Concepts/apisigningkey.htm">Oracle Cloud Infrastructure Documentation</a></p>'))
,p_attributes=>wwv_flow_t_plugin_attributes(wwv_flow_t_varchar2(
  'disabled', 'N',
  'submit_when_enter_pressed', 'N',
  'subtype', 'TEXT',
  'trim_spaces', 'BOTH')).to_clob
,p_ai_enabled=>false
);
wwv_flow_imp_page.create_page_item(
 p_id=>wwv_flow_imp.id(404104206969907963)
,p_name=>'P10_OCI_FINGERPRINT'
,p_item_sequence=>70
,p_item_plug_id=>wwv_flow_imp.id(397133122291984045)
,p_prompt=>'OCI Public Key Fingerprint'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>80
,p_field_template=>2526760615038828570
,p_item_template_options=>'#DEFAULT#'
,p_help_text=>'<p>Enter the <em>public RSA key fingerprint</em> for OCI authentication. </p><p><a rel="noopener noreferrer" target="_blank" href="https://docs.cloud.oracle.com/iaas/Content/API/Concepts/apisigningkey.htm">Oracle Cloud Infrastructure Documentation</a'
||'></p>'
,p_attributes=>wwv_flow_t_plugin_attributes(wwv_flow_t_varchar2(
  'disabled', 'N',
  'submit_when_enter_pressed', 'N',
  'subtype', 'TEXT',
  'trim_spaces', 'BOTH')).to_clob
,p_ai_enabled=>false
);
wwv_flow_imp_page.create_page_item(
 p_id=>wwv_flow_imp.id(405069916928490477)
,p_name=>'P10_OCI_REGION'
,p_is_required=>true
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_imp.id(379296506616163294)
,p_item_default=>'us-chicago-1'
,p_prompt=>'Region'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>80
,p_field_template=>2526760615038828570
,p_item_template_options=>'#DEFAULT#'
,p_help_text=>'The Oracle Cloud Infrastructure Region. The default is us-chicago-1'
,p_attributes=>wwv_flow_t_plugin_attributes(wwv_flow_t_varchar2(
  'disabled', 'N',
  'submit_when_enter_pressed', 'N',
  'subtype', 'TEXT',
  'trim_spaces', 'BOTH')).to_clob
,p_ai_enabled=>false
,p_show_quick_picks=>'Y'
,p_quick_pick_label_01=>'US Midwest (Chicago)'
,p_quick_pick_value_01=>'us-chicago-1'
,p_quick_pick_label_02=>'US East (Ashburn)'
,p_quick_pick_value_02=>'us-ashburn-1'
,p_quick_pick_label_03=>'US West (Phoenix)'
,p_quick_pick_value_03=>'us-phoenix-1'
,p_quick_pick_label_04=>'Germany Central (Frankfurt)'
,p_quick_pick_value_04=>'eu-frankfurt-1'
,p_quick_pick_label_05=>'UK South (London)'
,p_quick_pick_value_05=>'uk-london-1'
);
wwv_flow_imp_page.create_page_validation(
 p_id=>wwv_flow_imp.id(310701374885921409)
,p_validation_name=>'P10_OCI_USER_ID not null'
,p_validation_sequence=>10
,p_validation=>'P10_OCI_USER_ID'
,p_validation_type=>'ITEM_NOT_NULL'
,p_error_message=>'#LABEL# must have a value.'
,p_validation_condition=>'P10_SHOW_WEB_CREDENTIALS'
,p_validation_condition2=>'Y'
,p_validation_condition_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_when_button_pressed=>wwv_flow_imp.id(310700690737921411)
,p_associated_item=>wwv_flow_imp.id(404103902641907960)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_imp_page.create_page_validation(
 p_id=>wwv_flow_imp.id(310703007229921402)
,p_validation_name=>'P10_OCI_REGION not null'
,p_validation_sequence=>30
,p_validation=>'P10_OCI_REGION'
,p_validation_type=>'ITEM_NOT_NULL'
,p_error_message=>'#LABEL# must have a value.'
,p_when_button_pressed=>wwv_flow_imp.id(310700690737921411)
,p_associated_item=>wwv_flow_imp.id(405069916928490477)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_imp_page.create_page_validation(
 p_id=>wwv_flow_imp.id(310701731163921406)
,p_validation_name=>'P10_OCI_PRIVATE_KEY not null'
,p_validation_sequence=>50
,p_validation=>'P10_OCI_PRIVATE_KEY'
,p_validation_type=>'ITEM_NOT_NULL'
,p_error_message=>'#LABEL# must have a value.'
,p_validation_condition=>'P10_SHOW_WEB_CREDENTIALS'
,p_validation_condition2=>'Y'
,p_validation_condition_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_when_button_pressed=>wwv_flow_imp.id(310700690737921411)
,p_associated_item=>wwv_flow_imp.id(404103978846907961)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_imp_page.create_page_validation(
 p_id=>wwv_flow_imp.id(310702165732921405)
,p_validation_name=>'P10_OCI_TENANCY_ID not null'
,p_validation_sequence=>60
,p_validation=>'P10_OCI_TENANCY_ID'
,p_validation_type=>'ITEM_NOT_NULL'
,p_error_message=>'#LABEL# must have a value.'
,p_validation_condition=>'P10_SHOW_WEB_CREDENTIALS'
,p_validation_condition2=>'Y'
,p_validation_condition_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_when_button_pressed=>wwv_flow_imp.id(310700690737921411)
,p_associated_item=>wwv_flow_imp.id(404104081894907962)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_imp_page.create_page_validation(
 p_id=>wwv_flow_imp.id(310702551249921403)
,p_validation_name=>'P10_OCI_FINGERPRINT not null'
,p_validation_sequence=>70
,p_validation=>'P10_OCI_FINGERPRINT'
,p_validation_type=>'ITEM_NOT_NULL'
,p_error_message=>'#LABEL# must have a value.'
,p_validation_condition=>'P10_SHOW_WEB_CREDENTIALS'
,p_validation_condition2=>'Y'
,p_validation_condition_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_when_button_pressed=>wwv_flow_imp.id(310700690737921411)
,p_associated_item=>wwv_flow_imp.id(404104206969907963)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_imp_page.create_page_da_event(
 p_id=>wwv_flow_imp.id(310703691086921399)
,p_name=>'Toggle Switch Visibility'
,p_event_sequence=>10
,p_triggering_element_type=>'ITEM'
,p_triggering_element=>'P10_SHOW_WEB_CREDENTIALS'
,p_condition_element=>'P10_SHOW_WEB_CREDENTIALS'
,p_triggering_condition_type=>'EQUALS'
,p_triggering_expression=>'Y'
,p_bind_type=>'bind'
,p_execution_type=>'IMMEDIATE'
,p_bind_event_type=>'change'
);
wwv_flow_imp_page.create_page_da_action(
 p_id=>wwv_flow_imp.id(310704142685921397)
,p_event_id=>wwv_flow_imp.id(310703691086921399)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_SHOW'
,p_affected_elements_type=>'REGION'
,p_affected_region_id=>wwv_flow_imp.id(397133122291984045)
);
wwv_flow_imp_page.create_page_da_action(
 p_id=>wwv_flow_imp.id(310704711416921396)
,p_event_id=>wwv_flow_imp.id(310703691086921399)
,p_event_result=>'FALSE'
,p_action_sequence=>10
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_HIDE'
,p_affected_elements_type=>'REGION'
,p_affected_region_id=>wwv_flow_imp.id(397133122291984045)
);
wwv_flow_imp_page.create_page_process(
 p_id=>wwv_flow_imp.id(310703218260921401)
,p_process_sequence=>90
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Complete OCI'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'    l_vector    vector;',
'    l_response  clob;',
'begin',
'     ',
'   ',
'    if :P10_SHOW_WEB_CREDENTIALS = ''Y'' then',
'        apex_credential.set_persistent_credentials (',
'            p_credential_static_id  =>  ''RAG_CRED'',',
'            p_client_id             =>  :P10_OCI_USER_ID,',
'            p_client_secret         =>  :P10_OCI_PRIVATE_KEY,',
'            p_namespace             =>  :P10_OCI_TENANCY_ID,',
'            p_fingerprint           =>  :P10_OCI_FINGERPRINT',
'        );',
'',
'        :P10_OCI_PRIVATE_KEY := '' '';',
'    end if;',
'    apex_app_setting.set_value(''AGENT_ENDPOINT_ID'', :P10_OCI_AGENT_ENDPOINT);',
'    apex_app_setting.set_value(''OCI_AI_CRED'', ''RAG_CRED'');',
'    apex_app_setting.set_value(''BUCKET_NAME'', :P10_BUCKET_NAME);',
'    apex_app_setting.set_value(''COMPARTMENT_ID'', :P10_COMPARTMENT_ID);',
'    apex_app_setting.set_value(''NAMESPACE_NAME'', :P10_NAMESPACE_NAME);',
'    apex_app_setting.set_value(''REGION'', :P10_OCI_REGION);    ',
'    -- To turn the switch off by default from now on, since the web credentials have been entered successfully.',
'    if :P10_SHOW_WEB_CREDENTIALS = ''Y'' then',
'        apex_app_setting.set_value(''WC_STATUS'', ''ENTERED'');',
'    end if;',
'    -- To Complete Setup',
'    :INITIALIZED_AI_PROVIDER := ''YES'';',
'    apex_app_setting.set_value(''AI_PROVIDER_INITIALIZED'' ,''YES'');',
'end;'))
,p_process_clob_language=>'PLSQL'
,p_process_error_message=>'Invalid web credentials: #SQLERRM#'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_when_button_id=>wwv_flow_imp.id(310700690737921411)
,p_process_success_message=>'Success: Web credentials verified successfully.'
,p_internal_uid=>15764800139509542
);
wwv_flow_imp.component_end;
end;
/
