prompt --application/pages/page_00002
begin
--   Manifest
--     PAGE: 00002
--   Manifest End
wwv_flow_imp.component_begin (
 p_version_yyyy_mm_dd=>'2024.11.30'
,p_release=>'24.2.11'
,p_default_workspace_id=>7933254040897261
,p_default_application_id=>194
,p_default_id_offset=>217939551778601217
,p_default_owner=>'WKSP_WSDEMO'
);
wwv_flow_imp_page.create_page(
 p_id=>2
,p_name=>'Chat with OCI Generative AI Agent'
,p_alias=>'CHAT-WITH-OCI-GENERATIVE-AI-AGENT'
,p_step_title=>'Chat with OCI Generative AI Agent'
,p_autocomplete_on_off=>'OFF'
,p_inline_css=>wwv_flow_string.join(wwv_flow_t_varchar2(
'.t-Chat, .t-Chat .t-Comments {',
'  height: 470px;',
'  overflow: scroll;',
'}',
'',
'.t-Chat .t-Chat--own {',
'  flex-direction: row-reverse;',
'}',
'',
'.t-Chat .t-Chat--own .t-Comments-icon {',
'  margin: 0 0 0 12px;',
'}',
'',
'.t-Chat .t-Chat--own .t-Comments-body {',
'  align-items: flex-end;',
'}',
'',
'.t-Chat .t-Chat--own .t-Comments-comment:after {',
'  border-left-color: var(--ut-comment-chat-background-color);',
'  border-right-color: transparent;',
'  right: auto;',
'  left: 100%;',
'}'))
,p_page_template_options=>'#DEFAULT#'
,p_protection_level=>'C'
,p_page_component_map=>'13'
);
wwv_flow_imp_page.create_page_plug(
 p_id=>wwv_flow_imp.id(410563727221581844)
,p_plug_name=>'Chat with OCI Generative AI Agent'
,p_region_name=>'functional_chat'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>4501440665235496320
,p_plug_display_sequence=>90
,p_location=>null
,p_ai_enabled=>false
,p_attributes=>wwv_flow_t_plugin_attributes(wwv_flow_t_varchar2(
  'expand_shortcuts', 'N',
  'output_as', 'HTML')).to_clob
);
wwv_flow_imp_page.create_report_region(
 p_id=>wwv_flow_imp.id(408902580247347284)
,p_name=>'AI Agents Conversation'
,p_region_name=>'ai-agents-chat'
,p_parent_plug_id=>wwv_flow_imp.id(410563727221581844)
,p_template=>4501440665235496320
,p_display_sequence=>10
,p_region_css_classes=>'t-Chat u-padding-left-xl u-padding-right-xl u-margin-left-xl u-margin-right-xl'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#:t-Comments--chat'
,p_new_grid_row=>false
,p_display_point=>'SUB_REGIONS'
,p_source_type=>'NATIVE_SQL_REPORT'
,p_query_type=>'SQL'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select conv_ID,',
'       user_name,',
'       comment_text,',
'       comment_date,',
'       apex_string.get_initials(user_name) user_icon,',
'        case is_own',
'        when ''Yes'' then null',
'        else ''View Citations''',
'        end actions,',
'        case is_own',
'        when ''Yes'' then  ''<a href="#" class="set-value" data-ct="'' || REPLACE(comment_text, ''"'', ''&quot;'') || ''">Edit</a>''',
'        else null',
'        end actions_2,',
'        null                 as attribute_1,',
'        null                     as attribute_2,',
'        null                     as attribute_3,',
'        null                     as attribute_4,',
'       case is_own',
'        when ''Yes'' then ''t-Chat--own''',
'        else null',
'       end comment_modifiers,',
'        ''u-color-''||ora_hash(user_name,45) icon_modifier',
'  from RAG_CHATBOT',
'  Where session_ID = :P2_SESSION_ID',
'  order by comment_date asc '))
,p_ajax_enabled=>'Y'
,p_lazy_loading=>false
,p_query_row_template=>wwv_flow_imp.id(321967450485839294)
,p_query_num_rows=>50
,p_query_options=>'DERIVED_REPORT_COLUMNS'
,p_query_no_data_found=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div style="text-align: center; padding: 40px;">',
'  <h3 style="margin: 0 0 20px 0;">Start Conversation</h3>',
'  <p style="margin: 0 0 10px 0;">',
'    I can help you find information and generate insights on your data stored in OCI Object Storage. ',
'    Try asking a question like:',
'  </p>',
'  <blockquote style="margin: 0; font-style: italic;">',
unistr('    \201CWhat are the latest updates in our product documentation?\201D'),
'  </blockquote>',
'</div>',
''))
,p_query_row_count_max=>500
,p_csv_output=>'N'
,p_prn_output=>'N'
,p_prn_format=>'PDF'
,p_sort_null=>'L'
,p_plug_query_strip_html=>'N'
);
wwv_flow_imp_page.create_report_columns(
 p_id=>wwv_flow_imp.id(310716817619906181)
,p_query_column_id=>1
,p_column_alias=>'CONV_ID'
,p_column_display_sequence=>110
,p_column_heading=>'Conv Id'
,p_column_alignment=>'RIGHT'
,p_heading_alignment=>'RIGHT'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_imp_page.create_report_columns(
 p_id=>wwv_flow_imp.id(310717165141906179)
,p_query_column_id=>2
,p_column_alias=>'USER_NAME'
,p_column_display_sequence=>20
,p_column_heading=>'User Name'
,p_heading_alignment=>'LEFT'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_imp_page.create_report_columns(
 p_id=>wwv_flow_imp.id(310717579508906178)
,p_query_column_id=>3
,p_column_alias=>'COMMENT_TEXT'
,p_column_display_sequence=>30
,p_column_heading=>'Comment Text'
,p_heading_alignment=>'LEFT'
,p_display_as=>'RICH_TEXT'
,p_attribute_01=>'MARKDOWN'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_imp_page.create_report_columns(
 p_id=>wwv_flow_imp.id(310718017394906177)
,p_query_column_id=>4
,p_column_alias=>'COMMENT_DATE'
,p_column_display_sequence=>10
,p_column_heading=>'Comment Date'
,p_heading_alignment=>'LEFT'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_imp_page.create_report_columns(
 p_id=>wwv_flow_imp.id(310718355058906175)
,p_query_column_id=>5
,p_column_alias=>'USER_ICON'
,p_column_display_sequence=>40
,p_column_heading=>'User Icon'
,p_heading_alignment=>'LEFT'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_imp_page.create_report_columns(
 p_id=>wwv_flow_imp.id(310718792488906174)
,p_query_column_id=>6
,p_column_alias=>'ACTIONS'
,p_column_display_sequence=>50
,p_column_heading=>'Actions'
,p_column_link=>'f?p=&APP_ID.:7:&SESSION.::&DEBUG.::P7_CONV_ID:#CONV_ID#'
,p_column_linktext=>'#ACTIONS#'
,p_column_link_attr=>'target="_blank"'
,p_heading_alignment=>'LEFT'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_imp_page.create_report_columns(
 p_id=>wwv_flow_imp.id(310719162927906172)
,p_query_column_id=>7
,p_column_alias=>'ACTIONS_2'
,p_column_display_sequence=>160
,p_column_heading=>'Edit'
,p_column_format=>'PCT_GRAPH:::'
,p_heading_alignment=>'LEFT'
,p_display_as=>'WITHOUT_MODIFICATION'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_imp_page.create_report_columns(
 p_id=>wwv_flow_imp.id(310719569359906171)
,p_query_column_id=>8
,p_column_alias=>'ATTRIBUTE_1'
,p_column_display_sequence=>120
,p_column_heading=>'Attribute 1'
,p_heading_alignment=>'LEFT'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_imp_page.create_report_columns(
 p_id=>wwv_flow_imp.id(310720012692906169)
,p_query_column_id=>9
,p_column_alias=>'ATTRIBUTE_2'
,p_column_display_sequence=>130
,p_column_heading=>'Attribute 2'
,p_heading_alignment=>'LEFT'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_imp_page.create_report_columns(
 p_id=>wwv_flow_imp.id(310720373628906168)
,p_query_column_id=>10
,p_column_alias=>'ATTRIBUTE_3'
,p_column_display_sequence=>140
,p_column_heading=>'Attribute 3'
,p_heading_alignment=>'LEFT'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_imp_page.create_report_columns(
 p_id=>wwv_flow_imp.id(310720808327906167)
,p_query_column_id=>11
,p_column_alias=>'ATTRIBUTE_4'
,p_column_display_sequence=>150
,p_column_heading=>'Attribute 4'
,p_heading_alignment=>'LEFT'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_imp_page.create_report_columns(
 p_id=>wwv_flow_imp.id(310721140978906165)
,p_query_column_id=>12
,p_column_alias=>'COMMENT_MODIFIERS'
,p_column_display_sequence=>100
,p_column_heading=>'Comment Modifiers'
,p_heading_alignment=>'LEFT'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_imp_page.create_report_columns(
 p_id=>wwv_flow_imp.id(310721589280906164)
,p_query_column_id=>13
,p_column_alias=>'ICON_MODIFIER'
,p_column_display_sequence=>170
,p_column_heading=>'Icon Modifier'
,p_heading_alignment=>'LEFT'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_imp_page.create_page_plug(
 p_id=>wwv_flow_imp.id(410564178302581849)
,p_plug_name=>'Buttons'
,p_parent_plug_id=>wwv_flow_imp.id(410563727221581844)
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>4501440665235496320
,p_plug_display_sequence=>20
,p_plug_display_point=>'SUB_REGIONS'
,p_location=>null
,p_ai_enabled=>false
,p_attributes=>wwv_flow_t_plugin_attributes(wwv_flow_t_varchar2(
  'expand_shortcuts', 'N',
  'output_as', 'HTML')).to_clob
);
wwv_flow_imp_page.create_page_button(
 p_id=>wwv_flow_imp.id(310715302667906190)
,p_button_sequence=>10
,p_button_name=>'NewSession'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>4072362960822175091
,p_button_is_hot=>'Y'
,p_button_image_alt=>'New Session'
,p_button_position=>'BEFORE_NAVIGATION_BAR'
,p_icon_css_classes=>'fa-plus-square-o'
);
wwv_flow_imp_page.create_page_button(
 p_id=>wwv_flow_imp.id(310715703800906189)
,p_button_sequence=>20
,p_button_name=>'UploadDocuments'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#:t-Button--iconLeft'
,p_button_template_id=>2082829544945815391
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Upload Documents'
,p_button_position=>'BEFORE_NAVIGATION_BAR'
,p_button_redirect_url=>'f?p=&APP_ID.:6:&SESSION.::&DEBUG.:::'
,p_icon_css_classes=>'fa-cloud-upload'
);
wwv_flow_imp_page.create_page_button(
 p_id=>wwv_flow_imp.id(310722244248906161)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_imp.id(410564178302581849)
,p_button_name=>'Send'
,p_button_static_id=>'call-genai-agents'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#:t-Button--small'
,p_button_template_id=>2349107722467437027
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Send'
,p_warn_on_unsaved_changes=>null
,p_icon_css_classes=>'fa-arrow-circle-up'
,p_grid_column_attributes=>'style="align-self: center;"'
,p_grid_new_row=>'N'
,p_grid_new_column=>'Y'
,p_grid_column_span=>2
);
wwv_flow_imp_page.create_page_branch(
 p_id=>wwv_flow_imp.id(310732118079906122)
,p_branch_name=>'to Welcome Page'
,p_branch_action=>'f?p=&APP_ID.:100:&SESSION.::&DEBUG.:::&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'BEFORE_HEADER'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>10
,p_branch_condition_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_branch_condition=>'INITIALIZED_AI_PROVIDER'
,p_branch_condition_text=>'NO'
);
wwv_flow_imp_page.create_page_item(
 p_id=>wwv_flow_imp.id(310666143229094666)
,p_name=>'P2_REGION'
,p_item_sequence=>50
,p_item_default=>'apex_app_setting.get_value(p_name => ''REGION'')'
,p_item_default_type=>'EXPRESSION'
,p_item_default_language=>'PLSQL'
,p_display_as=>'NATIVE_HIDDEN'
,p_attributes=>wwv_flow_t_plugin_attributes(wwv_flow_t_varchar2(
  'value_protected', 'Y')).to_clob
);
wwv_flow_imp_page.create_page_item(
 p_id=>wwv_flow_imp.id(347870372036318070)
,p_name=>'P2_AGENT_ENDPOINT_ID'
,p_item_sequence=>30
,p_item_default=>'apex_app_setting.get_value(p_name => ''AGENT_ENDPOINT_ID'')'
,p_item_default_type=>'EXPRESSION'
,p_item_default_language=>'PLSQL'
,p_display_as=>'NATIVE_HIDDEN'
,p_attributes=>wwv_flow_t_plugin_attributes(wwv_flow_t_varchar2(
  'value_protected', 'Y')).to_clob
,p_ai_enabled=>false
);
wwv_flow_imp_page.create_page_item(
 p_id=>wwv_flow_imp.id(347870511127318071)
,p_name=>'P2_OCI_CRED'
,p_item_sequence=>40
,p_item_default=>'apex_app_setting.get_value(p_name => ''OCI_AI_CRED'')'
,p_item_default_type=>'EXPRESSION'
,p_item_default_language=>'PLSQL'
,p_display_as=>'NATIVE_HIDDEN'
,p_attributes=>wwv_flow_t_plugin_attributes(wwv_flow_t_varchar2(
  'value_protected', 'Y')).to_clob
);
wwv_flow_imp_page.create_page_item(
 p_id=>wwv_flow_imp.id(410579755918581814)
,p_name=>'P2_PROMPT'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_imp.id(410564178302581849)
,p_prompt=>'Prompt'
,p_placeholder=>'Enter your message...'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>30
,p_begin_on_new_line=>'N'
,p_colspan=>10
,p_field_template=>2040785906935475274
,p_item_template_options=>'#DEFAULT#:t-Form-fieldContainer--stretchInputs:t-Form-fieldContainer--large'
,p_attributes=>wwv_flow_t_plugin_attributes(wwv_flow_t_varchar2(
  'disabled', 'N',
  'submit_when_enter_pressed', 'N',
  'subtype', 'TEXT',
  'trim_spaces', 'BOTH')).to_clob
,p_ai_enabled=>false
);
wwv_flow_imp_page.create_page_item(
 p_id=>wwv_flow_imp.id(410581904857581828)
,p_name=>'P2_RESPONSE_SESSION'
,p_item_sequence=>20
,p_display_as=>'NATIVE_HIDDEN'
,p_attributes=>wwv_flow_t_plugin_attributes(wwv_flow_t_varchar2(
  'value_protected', 'Y')).to_clob
,p_ai_enabled=>false
);
wwv_flow_imp_page.create_page_item(
 p_id=>wwv_flow_imp.id(410582038976581829)
,p_name=>'P2_SESSION_ID'
,p_item_sequence=>60
,p_item_default=>wwv_flow_string.join(wwv_flow_t_varchar2(
'SELECT id ',
'FROM   JSON_TABLE(:P2_RESPONSE_SESSION, ''$''',
'       COLUMNS (id VARCHAR2(4000) PATH ''$.id'')',
'     ) jt;'))
,p_item_default_type=>'SQL_QUERY'
,p_display_as=>'NATIVE_HIDDEN'
,p_attributes=>wwv_flow_t_plugin_attributes(wwv_flow_t_varchar2(
  'value_protected', 'Y')).to_clob
);
wwv_flow_imp_page.create_page_item(
 p_id=>wwv_flow_imp.id(410583070784581839)
,p_name=>'P2_CONV_ID'
,p_item_sequence=>80
,p_display_as=>'NATIVE_HIDDEN'
,p_attributes=>wwv_flow_t_plugin_attributes(wwv_flow_t_varchar2(
  'value_protected', 'N')).to_clob
);
wwv_flow_imp_page.create_page_computation(
 p_id=>wwv_flow_imp.id(310724721008906148)
,p_computation_sequence=>10
,p_computation_item=>'P2_PROMPT'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'STATIC_ASSIGNMENT'
,p_computation_error_message=>'Clear the message if page is refreshed.'
);
wwv_flow_imp_page.create_page_computation(
 p_id=>wwv_flow_imp.id(310725181483906147)
,p_computation_sequence=>20
,p_computation_item=>'P2_SESSION_ID'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'STATIC_ASSIGNMENT'
);
wwv_flow_imp_page.create_page_da_event(
 p_id=>wwv_flow_imp.id(310726836719906139)
,p_name=>'Prompt Item Enter Key Action'
,p_event_sequence=>10
,p_triggering_element_type=>'ITEM'
,p_triggering_element=>'P2_PROMPT'
,p_triggering_condition_type=>'JAVASCRIPT_EXPRESSION'
,p_triggering_expression=>wwv_flow_string.join(wwv_flow_t_varchar2(
'this.browserEvent.key === ''Enter'' && !apex.item("P2_PROMPT").isEmpty()',
'',
''))
,p_bind_type=>'bind'
,p_execution_type=>'IMMEDIATE'
,p_bind_event_type=>'keydown'
);
wwv_flow_imp_page.create_page_da_action(
 p_id=>wwv_flow_imp.id(310727365314906137)
,p_event_id=>wwv_flow_imp.id(310726836719906139)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_JAVASCRIPT_CODE'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'this.browserEvent.preventDefault();',
'apex.event.trigger($("#call-genai-agents"), "click");',
''))
);
wwv_flow_imp_page.create_page_da_event(
 p_id=>wwv_flow_imp.id(310727719798906136)
,p_name=>'Interact with AI Agents on Button Click'
,p_event_sequence=>20
,p_triggering_element_type=>'BUTTON'
,p_triggering_button_id=>wwv_flow_imp.id(310722244248906161)
,p_triggering_condition_type=>'JAVASCRIPT_EXPRESSION'
,p_triggering_expression=>'!apex.item("P2_PROMPT").isEmpty()'
,p_bind_type=>'bind'
,p_execution_type=>'IMMEDIATE'
,p_bind_event_type=>'click'
);
wwv_flow_imp_page.create_page_da_action(
 p_id=>wwv_flow_imp.id(310729740837906129)
,p_event_id=>wwv_flow_imp.id(310727719798906136)
,p_event_result=>'TRUE'
,p_action_sequence=>20
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_EXECUTE_PLSQL_CODE'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'begin',
' insert into RAG_CHATBOT (user_name, is_own, comment_text, comment_date, session_ID)',
'   values (:APP_USER, ''Yes'', :P2_PROMPT, sysdate, :P2_SESSION_ID);',
'',
'end;'))
,p_attribute_02=>'P2_PROMPT,P2_SESSION_ID'
,p_attribute_03=>'P2_CONV_ID'
,p_attribute_04=>'N'
,p_attribute_05=>'PLSQL'
,p_wait_for_result=>'Y'
);
wwv_flow_imp_page.create_page_da_action(
 p_id=>wwv_flow_imp.id(310728259745906134)
,p_event_id=>wwv_flow_imp.id(310727719798906136)
,p_event_result=>'TRUE'
,p_action_sequence=>30
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_JAVASCRIPT_CODE'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'// $("#apex_wait_overlay").remove();',
'// $(".u-Processing").remove();',
'apex.region("ai-agents-chat").refresh();',
'var spinner = apex.util.showSpinner();'))
);
wwv_flow_imp_page.create_page_da_action(
 p_id=>wwv_flow_imp.id(310728723609906132)
,p_event_id=>wwv_flow_imp.id(310727719798906136)
,p_event_result=>'TRUE'
,p_action_sequence=>50
,p_execute_on_page_init=>'N'
,p_name=>'Calling RAG Agent'
,p_action=>'NATIVE_EXECUTE_PLSQL_CODE'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'    l_body       sys.json_object_t;',
'    l_response   clob;',
'    l_url        varchar2(2000);',
'    type citation_rec is record (',
'        source_text      varchar2(4000),',
'        source_location  varchar2(4000)',
'    );',
'    type citation_tab is table of citation_rec index by pls_integer;',
'    l_citations citation_tab;',
'    l_result   varchar2(32767);',
'    l_exists boolean;',
'    idx pls_integer := 0;',
'',
'begin',
'   ',
'        l_url := ''https://agent-runtime.generativeai.''',
'             || :P2_REGION',
'             ||''.oci.oraclecloud.com/20240531/agentEndpoints/''',
'             || :P2_AGENT_ENDPOINT_ID',
'             || ''/actions/chat'';    ',
'',
'    -- Construct JSON body using sys.json_object_t',
'    l_body := sys.json_object_t();',
'    l_body.put(''sessionId'', :P2_SESSION_ID);',
'    l_body.put(''shouldStream'', false); -- boolean value, not string',
'    l_body.put(''userMessage'', :P2_PROMPT);',
'',
'    apex_web_service.g_request_headers(1).name := ''Content-Type'';',
'    apex_web_service.g_request_headers(1).value := ''application/json'';',
'    ',
'    l_response := apex_web_service.make_rest_request(',
'                      p_url                  => l_url,',
'                      p_http_method          => ''POST'',',
'                      p_body                 => l_body.to_clob,',
'                      p_credential_static_id => :P2_OCI_CRED',
'                  );',
'',
'',
'        SELECT response_text into l_result',
'       FROM   JSON_TABLE(l_response, ''$.message[*]''',
'             COLUMNS (response_text varchar2(32767) PATH ''$.content.text''',
'                        )) jt;',
'',
'   insert into RAG_CHATBOT (user_name, is_own, comment_text, comment_date, session_ID)',
'   values (''AI'', ''No'', l_result, sysdate, :P2_SESSION_ID)',
'   returning CONV_ID into :P2_CONV_ID;',
'',
'for i in (',
'        SELECT jt.source_text, jt.source_location',
'        FROM JSON_TABLE(',
'            l_response, ',
'            ''$.traces[*]''',
'            COLUMNS (',
'                NESTED PATH ''$.citations[*]''',
'                COLUMNS (',
'                    source_text VARCHAR2(4000) PATH ''$.sourceText'',',
'                    source_location VARCHAR2(4000) PATH ''$.sourceLocation.url''',
'                )',
'            )',
'        ) jt',
'        where jt.source_text is not null and',
'              jt.source_location is not null',
'    ) loop',
'        l_exists := false;',
'        for j in 1 .. idx loop',
'            if l_citations(j).source_text = i.source_text and',
'               l_citations(j).source_location = i.source_location then',
'                l_exists := true;',
'                exit;',
'            end if;',
'        end loop;',
'',
'        if not l_exists then',
'            idx := idx + 1;',
'            l_citations(idx).source_text := i.source_text;',
'            l_citations(idx).source_location := i.source_location;',
'',
'            insert into RAG_CITATIONS (conv_id, prompt, source_text, source_location, asked_on) ',
'            values (:P2_CONV_ID,:P2_PROMPT, i.source_text,i.source_location, systimestamp);',
'        end if;',
'    end loop;',
'',
'end;'))
,p_attribute_02=>'P2_PROMPT,P2_SESSION_ID,P2_AGENT_ENDPOINT_ID,P2_OCI_CRED,P2_REGION'
,p_attribute_05=>'PLSQL'
,p_wait_for_result=>'Y'
);
wwv_flow_imp_page.create_page_da_action(
 p_id=>wwv_flow_imp.id(310729275713906131)
,p_event_id=>wwv_flow_imp.id(310727719798906136)
,p_event_result=>'TRUE'
,p_action_sequence=>110
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_JAVASCRIPT_CODE'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'apex.region("ai-agents-chat").refresh();',
'apex.item("P2_PROMPT").setValue("");',
'apex.item("P2_PROMPT").enable();',
'apex.item("P2_PROMPT").setFocus();',
'$("#apex_wait_overlay").remove();',
'$(".u-Processing").remove();'))
);
wwv_flow_imp_page.create_page_da_event(
 p_id=>wwv_flow_imp.id(310730130199906128)
,p_name=>'Scroll to bottom'
,p_event_sequence=>30
,p_triggering_element_type=>'REGION'
,p_triggering_region_id=>wwv_flow_imp.id(408902580247347284)
,p_bind_type=>'bind'
,p_execution_type=>'IMMEDIATE'
,p_bind_event_type=>'apexafterrefresh'
);
wwv_flow_imp_page.create_page_da_action(
 p_id=>wwv_flow_imp.id(310730706439906126)
,p_event_id=>wwv_flow_imp.id(310730130199906128)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_JAVASCRIPT_CODE'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'$("#ai-agents-chat .t-Comments").scrollTop($("#ai-agents-chat .t-Comments")[0].scrollHeight);',
''))
);
wwv_flow_imp_page.create_page_da_event(
 p_id=>wwv_flow_imp.id(310731106760906125)
,p_name=>'New'
,p_event_sequence=>40
,p_bind_type=>'bind'
,p_execution_type=>'IMMEDIATE'
,p_bind_event_type=>'ready'
);
wwv_flow_imp_page.create_page_da_action(
 p_id=>wwv_flow_imp.id(310731607728906124)
,p_event_id=>wwv_flow_imp.id(310731106760906125)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_JAVASCRIPT_CODE'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'document.addEventListener("click", function (e) {',
'    if (e.target && e.target.classList.contains("set-value")) {',
'        e.preventDefault();',
'        var commentText = e.target.getAttribute("data-ct");',
'        $s("P2_PROMPT", commentText);',
'    }',
'});',
''))
);
wwv_flow_imp_page.create_page_process(
 p_id=>wwv_flow_imp.id(310725472709906146)
,p_process_sequence=>10
,p_process_point=>'BEFORE_HEADER'
,p_process_type=>'NATIVE_INVOKE_API'
,p_process_name=>'Create Session'
,p_location=>'WEB_SOURCE'
,p_web_src_module_id=>wwv_flow_imp.id(353547761482139716)
,p_web_src_operation_id=>wwv_flow_imp.id(353548099928139717)
,p_attribute_01=>'WEB_SOURCE'
,p_internal_uid=>15787054588494287
);
wwv_flow_imp_shared.create_web_source_comp_param(
 p_id=>wwv_flow_imp.id(294944029619394554)
,p_page_id=>2
,p_web_src_param_id=>wwv_flow_imp.id(294943683246394565)
,p_page_process_id=>wwv_flow_imp.id(310725472709906146)
,p_value_type=>'EXPRESSION'
,p_value_language=>'PLSQL'
,p_value=>'apex_app_setting.get_value(p_name => ''REGION'')'
);
wwv_flow_imp_shared.create_web_source_comp_param(
 p_id=>wwv_flow_imp.id(310726511015906141)
,p_page_id=>2
,p_web_src_param_id=>wwv_flow_imp.id(353549045478139718)
,p_page_process_id=>wwv_flow_imp.id(310725472709906146)
,p_value_type=>'ITEM'
,p_value=>'P2_RESPONSE_SESSION'
,p_ignore_output=>false
);
wwv_flow_imp_shared.create_web_source_comp_param(
 p_id=>wwv_flow_imp.id(313091024740602284)
,p_page_id=>2
,p_web_src_param_id=>wwv_flow_imp.id(313090719651602306)
,p_page_process_id=>wwv_flow_imp.id(310725472709906146)
,p_value_type=>'EXPRESSION'
,p_value_language=>'PLSQL'
,p_value=>'apex_app_setting.get_value(p_name => ''AGENT_ENDPOINT_ID'')'
);
wwv_flow_imp.component_end;
end;
/
