prompt --application/deployment/install/install_ai_agents_sql
begin
--   Manifest
--     INSTALL: INSTALL-AI-Agents.sql
--   Manifest End
wwv_flow_imp.component_begin (
 p_version_yyyy_mm_dd=>'2024.11.30'
,p_release=>'24.2.11'
,p_default_workspace_id=>7933254040897261
,p_default_application_id=>194
,p_default_id_offset=>217939551778601217
,p_default_owner=>'WKSP_WSDEMO'
);
wwv_flow_imp_shared.create_install_script(
 p_id=>wwv_flow_imp.id(310762256196872011)
,p_install_id=>wwv_flow_imp.id(357304887572543598)
,p_name=>'AI-Agents.sql'
,p_sequence=>10
,p_script_type=>'INSTALL'
,p_script_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'CREATE TABLE "DOC_UPLOAD" (',
'    "ID"                 NUMBER',
'        GENERATED BY DEFAULT ON NULL AS IDENTITY MINVALUE 1 MAXVALUE 9999999999999999999999999999 INCREMENT BY 1 START WITH 1 CACHE 20',
'        NOORDER NOCYCLE NOKEEP NOSCALE',
'    NOT NULL ENABLE,',
'    "FILE_NAME"          VARCHAR2(4000 CHAR),',
'    "MIME_TYPE"          VARCHAR2(4000 CHAR),',
'    "OBJECT_STORAGE_URL" VARCHAR2(4000 CHAR),',
'    "CREATED"            DATE NOT NULL ENABLE,',
'    "CREATED_BY"         VARCHAR2(255 CHAR) NOT NULL ENABLE,',
'    "UPDATED"            DATE NOT NULL ENABLE,',
'    "UPDATED_BY"         VARCHAR2(255 CHAR) NOT NULL ENABLE,',
'    "INGESTION_RESPONSE" VARCHAR2(100),',
'    "DATA_ING_JOB_ID"    VARCHAR2(300),',
'    CONSTRAINT "DOC_UPLOAD_ID_PK" PRIMARY KEY ( "ID" )',
'        USING INDEX ENABLE',
');',
'',
'CREATE TABLE "RAG_CHATBOT" (',
'    "CONV_ID"      NUMBER',
'        GENERATED BY DEFAULT ON NULL AS IDENTITY MINVALUE 1 MAXVALUE 9999999999999999999999999999 INCREMENT BY 1 START WITH 1 CACHE 20',
'        NOORDER NOCYCLE NOKEEP NOSCALE',
'    NOT NULL ENABLE,',
'    "USER_NAME"    VARCHAR2(255 CHAR),',
'    "COMMENT_TEXT" VARCHAR2(32767 CHAR),',
'    "COMMENT_DATE" DATE,',
'    "IS_OWN"       VARCHAR2(10 CHAR),',
'    "SESSION_ID"   VARCHAR2(500),',
'    CONSTRAINT "RAG_CHATBOT_ID_PK" PRIMARY KEY ( "CONV_ID" )',
'        USING INDEX ENABLE',
');',
'',
'CREATE TABLE "RAG_CITATIONS" (',
'    "ID"              NUMBER',
'        GENERATED BY DEFAULT ON NULL AS IDENTITY MINVALUE 1 MAXVALUE 9999999999999999999999999999 INCREMENT BY 1 START WITH 1 CACHE 20',
'        NOORDER NOCYCLE NOKEEP NOSCALE',
'    NOT NULL ENABLE,',
'    "CONV_ID"         NUMBER,',
'    "PROMPT"          VARCHAR2(4000 CHAR),',
'    "SOURCE_TEXT"     VARCHAR2(4000 CHAR),',
'    "SOURCE_LOCATION" VARCHAR2(4000 CHAR),',
'    "ASKED_ON"        DATE,',
'    CONSTRAINT "RAG_CITATIONS_ID_PK" PRIMARY KEY ( "ID" )',
'        USING INDEX ENABLE',
');',
'',
'CREATE OR REPLACE EDITIONABLE TRIGGER "DOC_UPLOAD_BIU" BEFORE',
'    INSERT OR UPDATE ON DOC_UPLOAD',
'    FOR EACH ROW',
'BEGIN',
'    IF INSERTING THEN',
'        :NEW.CREATED := SYSDATE;',
'        :NEW.CREATED_BY := COALESCE(',
'            SYS_CONTEXT(''APEX$SESSION'', ''APP_USER''),',
'            USER',
'        );',
'    END IF;',
'',
'    :NEW.UPDATED := SYSDATE;',
'    :NEW.UPDATED_BY := COALESCE(',
'        SYS_CONTEXT(''APEX$SESSION'', ''APP_USER''),',
'        USER',
'    );',
'END DOC_UPLOAD_BIU;',
'/',
'',
'ALTER TRIGGER "DOC_UPLOAD_BIU" ENABLE;',
'',
'CREATE OR REPLACE FUNCTION URL_ENCODE (',
'    P_STR IN VARCHAR2',
') RETURN VARCHAR2 IS',
'BEGIN',
'    RETURN SYS.UTL_URL.ESCAPE(',
'        URL                   => P_STR,',
'        ESCAPE_RESERVED_CHARS => TRUE,',
'        URL_CHARSET           => ''AL32UTF8''',
'    );',
'END URL_ENCODE;',
'/',
'',
'CREATE SEQUENCE "INGESTION_SEQ" MINVALUE 1 MAXVALUE 999999999999999999999999999 INCREMENT BY 1 START WITH 501 CACHE 20 NOORDER NOCYCLE',
'NOKEEP NOSCALE',
'',
'GLOBAL;',
'/',
'',
'CREATE OR REPLACE PACKAGE OCI_OBJECT_STORAGE_UTILS IS',
'    PROCEDURE UPLOAD_FILE (',
'        P_FILE_CONTENT       IN VARCHAR2,',
'        P_STATIC_ID          IN VARCHAR2,',
'        P_NAMESPACE          IN VARCHAR2,',
'        P_BUCKET             IN VARCHAR2,',
'        P_REGION             IN VARCHAR2,',
'        P_OBJECT_STORAGE_URL OUT VARCHAR2,',
'        P_FILE_NAME          OUT VARCHAR2,',
'        P_MIME_TYPE          OUT VARCHAR2',
'    );',
'',
'    PROCEDURE GET_FILE (',
'        P_ID IN NUMBER',
'    );',
'',
'    PROCEDURE DELETE_FILE (',
'        P_OBJECT_STORAGE_URL IN VARCHAR2,',
'        P_STATIC_ID          IN VARCHAR2,',
'        P_MIME_TYPE          IN VARCHAR2',
'    );',
'',
'END OCI_OBJECT_STORAGE_UTILS;',
'/',
'',
'CREATE OR REPLACE PACKAGE BODY OCI_OBJECT_STORAGE_UTILS IS',
'',
'    PROCEDURE UPLOAD_FILE (',
'        P_FILE_CONTENT       IN VARCHAR2,',
'        P_STATIC_ID          IN VARCHAR2,',
'        P_NAMESPACE          IN VARCHAR2,',
'        P_BUCKET             IN VARCHAR2,',
'        P_REGION             IN VARCHAR2,',
'        P_OBJECT_STORAGE_URL OUT VARCHAR2,',
'        P_FILE_NAME          OUT VARCHAR2,',
'        P_MIME_TYPE          OUT VARCHAR2',
'    ) IS',
'        L_OBJECT   BLOB;',
'        L_RESPONSE CLOB;',
'    BEGIN',
'        SELECT',
'            BLOB_CONTENT,',
'            FILENAME,',
'            MIME_TYPE',
'        INTO',
'            L_OBJECT,',
'            P_FILE_NAME,',
'            P_MIME_TYPE',
'        FROM',
'            APEX_APPLICATION_TEMP_FILES',
'        WHERE',
'            NAME = P_FILE_CONTENT;',
'',
'        P_OBJECT_STORAGE_URL := ''https://objectstorage.''',
'                                || P_REGION',
'                                || ''.oraclecloud.com/n/''',
'                                || P_NAMESPACE',
'                                || ''/b/''',
'                                || P_BUCKET',
'                                || ''/o/''',
'                                || URL_ENCODE(P_FILE_NAME);',
'',
'        APEX_WEB_SERVICE.G_REQUEST_HEADERS(1).NAME := ''Content-Type'';',
'        APEX_WEB_SERVICE.G_REQUEST_HEADERS(1).VALUE := P_MIME_TYPE;',
'        L_RESPONSE := APEX_WEB_SERVICE.MAKE_REST_REQUEST(',
'            P_URL                  => P_OBJECT_STORAGE_URL,',
'            P_HTTP_METHOD          => ''PUT'',',
'            P_BODY_BLOB            => L_OBJECT,',
'            P_CREDENTIAL_STATIC_ID => P_STATIC_ID',
'        );',
'',
'        IF APEX_WEB_SERVICE.G_STATUS_CODE != 200 THEN',
'            RAISE_APPLICATION_ERROR(-20000, ''Upload failed - '' || APEX_WEB_SERVICE.G_STATUS_CODE);',
'        END IF;',
'',
'    END UPLOAD_FILE;',
'',
'    PROCEDURE GET_FILE (',
'        P_ID IN NUMBER',
'    ) IS',
'',
'        L_BLOB      BLOB;',
'        L_URL       VARCHAR2(255);',
'        L_MIME_TYPE VARCHAR2(50);',
'        L_FILE_NAME VARCHAR2(100);',
'    BEGIN',
'        SELECT',
'            MIME_TYPE,',
'            OBJECT_STORAGE_URL,',
'            FILE_NAME',
'        INTO',
'            L_MIME_TYPE,',
'            L_URL,',
'            L_FILE_NAME',
'        FROM',
'            DOC_UPLOAD',
'        WHERE',
'            ID = P_ID;',
'',
'        L_BLOB := APEX_WEB_SERVICE.MAKE_REST_REQUEST_B(',
'            P_URL                  => L_URL,',
'            P_HTTP_METHOD          => ''GET'',',
'            P_CREDENTIAL_STATIC_ID => ''RAG_CRED''',
'        );',
'',
'        APEX_HTTP.DOWNLOAD(',
'            P_BLOB         => L_BLOB,',
'            P_CONTENT_TYPE => L_MIME_TYPE,',
'            P_FILENAME     => L_FILE_NAME',
'        );',
'',
'        APEX_APPLICATION.STOP_APEX_ENGINE;',
'    END GET_FILE;',
'',
'    PROCEDURE DELETE_FILE (',
'        P_OBJECT_STORAGE_URL IN VARCHAR2,',
'        P_STATIC_ID          IN VARCHAR2,',
'        P_MIME_TYPE          IN VARCHAR2',
'    ) IS',
'        L_RESPONSE CLOB;',
'    BEGIN',
'        APEX_WEB_SERVICE.G_REQUEST_HEADERS(1).NAME := ''Content-Type'';',
'        APEX_WEB_SERVICE.G_REQUEST_HEADERS(1).VALUE := P_MIME_TYPE;',
'        L_RESPONSE := APEX_WEB_SERVICE.MAKE_REST_REQUEST(',
'            P_URL                  => P_OBJECT_STORAGE_URL,',
'            P_HTTP_METHOD          => ''DELETE'',',
'            P_CREDENTIAL_STATIC_ID => P_STATIC_ID',
'        );',
'',
'    END DELETE_FILE;',
'',
'END OCI_OBJECT_STORAGE_UTILS;',
'/'))
);
wwv_flow_imp.component_end;
end;
/
